<?php

namespace AlloCine\BrandBundle\Tests\Tools;

use AlloCine\BrandBundle\Tools\RoutingTools;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

class RoutingToolsTest extends \PHPUnit_Framework_TestCase
{
    public function testDebrand()
    {
        $this->assertSame('home', RoutingTools::debrand('home'));
        $this->assertSame('home', RoutingTools::debrand('brand1__home'));
    }

    public function testFilterBrand()
    {
        $routes = new RouteCollection();
        $routes->add('brand1__home', new Route('/', ['_brand' => 'brand1']));
        $routes->add('brand2__home', new Route('/', ['_brand' => 'brand2']));
        $routes->add('regular', new Route('/regular'));

        $routes = RoutingTools::filterBrand($routes, 'brand1');

        $this->assertNull($routes->get('brand2__home'));
        $this->assertNotNull($routes->get('brand1__home'));
        $this->assertNotNull($routes->get('regular'));
        $this->assertSame(2, $routes->count());
    }
}
