<?php

declare(strict_types=1);

namespace AlloCine\BrandBundle\Tests;

use Override;
use Exception;
use AlloCine\BrandBundle\Kernel\BrandableKernel;
use Symfony\Bundle\FrameworkBundle\Kernel\MicroKernelTrait;
use Symfony\Component\Config\Loader\LoaderInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Routing\RouteCollection;

class TestKernel extends BrandableKernel
{
    use MicroKernelTrait;

    public function registerBundles(): iterable
    {
        return [];
    }

    #[Override]
    public function getProjectDir(): string
    {
        return __DIR__ . '/../Tests/Resources';
    }

    #[Override]
    public function boot(): void
    {
        $this->booted = true;
    }

    /**
     * @throws Exception
     *
     */
    #[Override]
    public function configureContainer(ContainerBuilder $container, LoaderInterface $loader): void
    {
        parent::configureContainer($container, $loader);
    }

    protected function configureRoutes(RouteCollection $routes): void
    {
    }
}
