<?php

declare(strict_types=1);

namespace AlloCine\BrandBundle\Routing\Extension;

use Symfony\Component\Routing\RouteCollection;

/**
 * Allows to take control of the route loading process with small extensions.
 *
 * The method doc is based around the example of adding a "disable" boolean field in
 * the routing configuration :
 *
 * myroute:
 *    path: /foo
 *    options:
 *        disable: true
 */
interface LoaderExtensionInterface
{
    /**
     * Returns the extension name.
     */
    public function getName(): string;

    /**
     * Allows to perform custom checks on the routing config.
     *
     * Example usage: Checking the "disabled" custom configuration field is a boolean.
     */
    public function validate($config): void;

    /**
     * Allow to manipulate the full RouteCollection after the loader
     * finished its job.
     *
     * Example usage : Removing disabled routes.
     */
    public function postLoad(RouteCollection $collection): void;
}
