<?php

declare(strict_types=1);

namespace AlloCine\BrandBundle\Routing\Extension;

interface GeneratorExtensionInterface
{
    /**
     * Overrides the name of the route during URL generation
     *
     * Example usage : changing the route name for another one based on some context.
     */
    public function overrideName(string $name, array $parameters): string;

    /**
     * Overrides the parameters of the route during URL generation.
     *
     * Example usage : adding a parameter to every route.
     */
    public function overrideParameters(string $name, array $parameters): array;
}
