<?php

declare(strict_types=1);

namespace AlloCine\BrandBundle\Model;

class Brand
{
    private readonly string $host;

    private readonly string $locale;

    private array $extras;

    public function __construct(private readonly string $name, array $config)
    {
        $this->host = $config['host'] ?? null;
        $this->locale = $config['locale'] ?? null;
        $this->extras = $config['extras'] ?? [];
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getExtra(string $name, mixed $default = null): mixed
    {
        return $this->extras[$name] ?? $default;
    }

    public function getExtras(): array
    {
        return $this->extras;
    }

    public function getHost(): ?string
    {
        return $this->host;
    }

    public function getLocale(): ?string
    {
        return $this->locale;
    }
}
