<?php

namespace AlloCine\BrandBundle\Command;

use \Symfony\Component\Console\Command\Command;
use Symfony\Component\DependencyInjection\ContainerAwareTrait;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Symfony\Component\DependencyInjection\ParameterBag\ParameterBagInterface;
use Symfony\Component\HttpKernel\KernelInterface;

abstract class Base extends Command
{
    use ContainerAwareTrait;

    /**
     * @var ParameterBagInterface
     */
    protected $parameterBag;

    /**
     * @var KernelInterface
     */
    protected $kernel;


    /**
     * Command constructor.
     *
     * @param ParameterBagInterface $parameterBag
     * @param string|null           $name
     */
    public function __construct(ParameterBagInterface $parameterBag, string $name = null) {
        parent::__construct($name);

        $this->parameterBag = $parameterBag;
    }
}
