<?php

namespace AlloCine\BrandBundle\Tests;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase as BaseWebTestCase;
use Symfony\Component\HttpKernel\KernelInterface;

abstract class WebTestCase extends BaseWebTestCase
{
    public function get(string $name): object
    {
        if (null === static::$kernel) {
            throw new \Exception(sprintf('You must call static::bootKernel before call "container->get(\'%s\')"', $name));
        }

        return static::$kernel->getContainer()->get($name);
    }

    /**
     * Creates a Kernel.
     *
     * Available options:
     *
     *  * environment
     *  * debug
     */
    protected static function createKernel(array $options = []): KernelInterface
    {
        if (null === static::$class) {
            static::$class = static::getKernelClass();
        }

        return new static::$class(
            $options['environment'] ?? 'test',
            $options['debug'] ?? true,
            $options['brand'] ?? null
        );
    }
}
