<?php

namespace AlloCine\BrandBundle\Tests\Model;

use AlloCine\BrandBundle\Model\BrandRepository;
use PHPUnit\Framework\TestCase;

class BrandRepositoryTest extends TestCase
{
    public function testAll()
    {
        $brands = $this->getRepository()->all();

        $this->assertCount(2, $brands);
        $this->assertSame('brand1.com', $brands['brand1']->getHost());
        $this->assertSame('brand2.com', $brands['brand2']->getHost());
    }

    public function testGet()
    {
        $this->assertSame('brand1.com', $this->getRepository()->get('brand1')->getHost());
    }

    public function testUnknownBrand()
    {
        $this->expectException(\InvalidArgumentException::class);
        $this->expectExceptionMessage('Could not find brand "otherbrand"');

        $this->getRepository()->get('otherbrand');
    }

    public function testAvailableBrands()
    {
        $this->assertSame(['brand1', 'brand2'], $this->getRepository()->getAvailableBrands());
    }

    private function getRepository(): BrandRepository
    {
        return new BrandRepository([
            'brand1' => ['host' => 'brand1.com', 'locale' => 'en_US'],
            'brand2' => ['host' => 'brand2.com', 'locale' => 'fr_FR']
        ]);
    }
}
