<?php

namespace AlloCine\BrandBundle\Routing\Extension;

interface GeneratorExtensionInterface
{
    /**
     * Overrides the name of the route during URL generation
     *
     * @param string $name
     * @param array  $parameters
     *
     * Example usage : changing the route name for another one based on some context.
     *
     * @return string
     */
    public function overrideName($name, array $parameters);

    /**
     * Overrides the parameters of the route during URL generation.
     *
     * Example usage : adding a parameter to every routes.
     *
     * @param string $name
     * @param array $parameters
     *
     * @return array
     */
    public function overrideParameters($name, array $parameters);
}
