<?php

declare(strict_types=1);

namespace AlloCine\BrandBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\ArrayNodeDefinition;
use Symfony\Component\Config\Definition\Builder\NodeDefinition;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;

class ConfigRootNodeVersionHelper
{
    /**
     * @internal
     *
     * @return ArrayNodeDefinition|NodeDefinition
     */
    public static function getRootNodeWithoutDeprecation(TreeBuilder $builder, ?string $name, string $type = 'array')
    {
        // BC layer for symfony/config 4.1 and older
        return method_exists($builder, 'getRootNode') ? $builder->getRootNode() : $builder->root($name, $type);
    }
}
