<?php

namespace AlloCine\BrandBundle\DependencyInjection\Compiler;

use AlloCine\BrandBundle\Model\FolderRepository;
use Symfony\Component\DependencyInjection\Compiler\CompilerPassInterface;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class TemplatePass implements CompilerPassInterface
{
    /**
     * {@inheritDoc}
     */
    public function process(ContainerBuilder $container)
    {
        // When twig is not used by the project, do nothing
        if (! $container->has('twig')) {
            return;
        }

        $brand                = $container->getParameter('brand');
        $folders              = $container->getParameter('branding.folders');
        $twigLoaderDefinition = $container->findDefinition('alias.twig.loader.filesystem');
        $folderRepository     = new FolderRepository([$brand], $folders);

        $container->getParameterBag()->remove('branding.folders');

        foreach ($folderRepository->getTaggedFolders('twig', $brand) as $path) {
            $twigLoaderDefinition->addMethodCall('addPath', [$path]);
        }
    }
}
