<?php

declare(strict_types=1);

namespace AlloCine\BrandBundle\Tests\Model;

use InvalidArgumentException;
use AlloCine\BrandBundle\Model\BrandRepository;
use PHPUnit\Framework\TestCase;

final class BrandRepositoryTest extends TestCase
{
    public function testAll(): void
    {
        $brands = $this->getRepository()->all();

        $this->assertSame(2, count($brands));
        $this->assertSame('brand1.com', $brands['brand1']->getHost());
        $this->assertSame('brand2.com', $brands['brand2']->getHost());
    }

    public function testGet(): void
    {
        $this->assertSame('brand1.com', $this->getRepository()->get('brand1')->getHost());
    }

    public function testUnknownBrand(): void
    {
        $this->expectException(InvalidArgumentException::class);
        $this->expectExceptionMessage('Could not find brand "otherbrand"');
        $this->getRepository()->get('otherbrand');
    }

    public function testAvailableBrands(): void
    {
        $this->assertSame(['brand1', 'brand2'], $this->getRepository()->getAvailableBrands());
    }

    private function getRepository(): BrandRepository
    {
        return new BrandRepository([
            'brand1' => ['host' => 'brand1.com', 'locale' => 'en_US'],
            'brand2' => ['host' => 'brand2.com', 'locale' => 'fr_FR']
        ]);
    }
}
