<?php

declare(strict_types=1);

namespace AlloCine\BrandBundle\Model;

use InvalidArgumentException;

class BrandRepository
{
    public function __construct(private readonly array $brands)
    {
    }

    public function get(string $name): Brand
    {
        if (!array_key_exists($name, $this->brands)) {
            throw new InvalidArgumentException(sprintf('Could not find brand "%s".', $name));
        }

        return new Brand($name, $this->brands[$name]);
    }

    public function all(): array
    {
        $brands = [];

        foreach ($this->brands as $name => $data) {
            $brands[$name] = new Brand($name, $data);
        }

        return $brands;
    }

    public function getAvailableBrands(): array
    {
        return array_keys($this->brands);
    }

    public function getEnabledBrands(): array
    {
        $brands = [];

        foreach ($this->brands as $k => $v) {
            if ($v['enabled']) {
                $brands[] = $k;
            }
        }
        return $brands;
    }
}
