<?php

declare(strict_types=1);

namespace AlloCine\BrandBundle\DependencyInjection\Binding;

use AlloCine\BrandBundle\Model\BrandRepository;
use AlloCine\BrandBundle\Model\FolderRepository;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class AllocineI18nBinding
{
    public function __construct(
        private readonly BrandRepository $brandRepository,
        private readonly FolderRepository $folderRepository
    ) {
    }

    public function bind(ContainerBuilder $container, array $binding): void
    {
        $bundles = array_keys($container->getParameter('kernel.bundles'));

        if (!in_array('AlloCineI18NBundle', $bundles)) {
            return;
        }

        $sourcePaths = [];
        $locales = [];

        foreach ($binding['sourceFolders'] as $tag) {
            foreach ($this->folderRepository->getAllTaggedFolders($tag) as $folder) {
                $sourcePaths[] = $folder;
            }
        }

        foreach ($this->brandRepository->all() as $brand) {
            $locales[] = $brand->getLocale();
        }

        $container->prependExtensionConfig('allo_cine_i18_n', [
            'locales' => array_unique($locales),
            'sourcePaths' => $sourcePaths
        ]);
    }
}
