<?php

namespace AlloCine\BrandBundle\Model;

class Brand
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $host;

    /**
     * @var string
     */
    private $locale;

    /**
     * @var array
     */
    private $extras;

    /**
     * @param string $name
     * @param array  $config
     */
    public function __construct(string $name, array $config)
    {
        $this->name = $name;
        $this->host = $config['host'] ?? null;
        $this->locale = $config['locale'] ?? null;
        $this->extras = $config['extras'] ?? [];
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @param mixed  $default
     *
     * @return mixed
     */
    public function getExtra($name, $default = null)
    {
        return $this->extras[$name] ?? $default;
    }

    /**
     * @return array
     */
    public function getExtras(): array
    {
        return $this->extras;
    }

    /**
     * @return string|null
     */
    public function getHost()
    {
        return $this->host;
    }

    /**
     * @return string|null
     */
    public function getLocale()
    {
        return $this->locale;
    }
}
