<?php

namespace AlloCine\BrandBundle\DependencyInjection;

use AlloCine\BrandBundle\Model\BrandRepository;
use AlloCine\BrandBundle\Model\FolderRepository;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\DependencyInjection\Extension\PrependExtensionInterface;
use Symfony\Component\DependencyInjection\Loader\YamlFileLoader;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;

class AlloCineBrandExtension extends Extension implements PrependExtensionInterface
{
    /**
     * @inheritdoc
     */
    public function prepend(ContainerBuilder $container)
    {
        $configs = $container->getExtensionConfig($this->getAlias());

        // Resolves parameters as it is not done at the prepend stage of building
        // the container.
        $configs = $container->getParameterBag()->resolveValue($configs);

        $config = $this->processConfiguration(new Configuration(), $configs);

        $currentBrand = $container->getParameter('brand');
        $container->setParameter('brand.locale', $config['brands'][$currentBrand]['locale']);

        $brandRepository = new BrandRepository($config['brands']);
        $folderRepository = new FolderRepository(array_keys($config['brands']), $config['folders']);

        foreach ($config['bindings'] as $name => $binding) {
            $class = sprintf('AlloCine\BrandBundle\DependencyInjection\Binding\%sBinding', ucfirst($name));
            (new $class($brandRepository, $folderRepository))->bind($container, $binding);
        }
    }

    /**
     * @inheritdoc
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new YamlFileLoader($container, new FileLocator(__DIR__ . '/../Resources/config'));
        $loader->load('services.yml');

        if ($config['builtins']['cache']['enabled'] && !$config['builtins']['cache']['skip']) {
            $loader->load('cache_extension.yml');

            $container
                ->getDefinition('brand.builtin.cache_extension')
                ->addArgument($config['builtins']['cache']['default_ttl'])
            ;
        }

        $container->setParameter('branding.folders', $config['folders']);

        $container->getDefinition('brand.brand_repository')->setArguments([ $config['brands'] ]);
        $container->getDefinition('brand.folder_repository')
            ->addArgument($config['folders'])
            ->addArgument($container->getParameter('brand'))
        ;
    }
}
