<?php

namespace AlloCine\BrandBundle\Model;

class BrandRepository
{
    /**
     * @var array
     */
    private $brands;

    /**
     * @param array $brands
     */
    public function __construct(array $brands)
    {
        $this->brands = $brands;
    }

    /**
     * @param string $name
     *
     * @return Brand
     */
    public function get($name): Brand
    {
        if (!array_key_exists($name, $this->brands)) {
            throw new \InvalidArgumentException(sprintf('Could not find brand "%s".', $name));
        }

        return new Brand($name, $this->brands[$name]);
    }

    /**
     * @return Brand[]
     */
    public function all(): array
    {
        $brands = [];

        foreach ($this->brands as $name => $data) {
            $brands[$name] = new Brand($name, $data);
        }

        return $brands;
    }

    /**
     * @return string[]
     */
    public function getAvailableBrands(): array
    {
        return array_keys($this->brands);
    }

    /**
     * @return string[]
     */
    public function getEnabledBrands(): array
    {
        $brands = [];

        foreach ($this->brands as $k => $v) {
            if ($v['enabled']) {
                $brands[] = $k;
            }
        }
        return $brands;
    }
}
