<?php

namespace AlloCine\BrandBundle\Console;

use Symfony\Bundle\FrameworkBundle\Console\Application as BaseApplication;
use Symfony\Component\HttpKernel\KernelInterface;
use Symfony\Component\Console\Input\InputOption;

/**
 * Application add brand option for every command
 *
 * @author Xavier HAUSHERR <xhausherr@allocine.fr>
 */
class Application extends BaseApplication
{
    /**
     * @param KernelInterface $kernel
     */
    public function __construct(KernelInterface $kernel)
    {
        parent::__construct($kernel);

        $this->getDefinition()->addOption(new InputOption('--brand', 'b', InputOption::VALUE_REQUIRED, 'Application Brand.', $kernel->getBrand()));
    }
}
