<?php

namespace AlloCine\BrandBundle\Tests\Model;

use AlloCine\BrandBundle\Model\BrandRepository;

class BrandRepositoryTest extends \PHPUnit_Framework_TestCase
{
    public function testAll()
    {
        $brands = $this->getRepository()->all();

        $this->assertSame(2, count($brands));
        $this->assertSame('brand1.com', $brands['brand1']['host']);
        $this->assertSame('brand2.com', $brands['brand2']['host']);
    }

    public function testGet()
    {
        $this->assertSame('brand1.com', $this->getRepository()->get('brand1')['host']);
    }

    /**
     * @expectedException \InvalidArgumentException
     * @expectedExceptionMessage Could not find brand "otherbrand"
     */
    public function testUnknownBrand()
    {
        $this->getRepository()->get('otherbrand');
    }

    public function testAvailableBrands()
    {
        $this->assertSame(['brand1', 'brand2'], $this->getRepository()->getAvailableBrands());
    }

    /**
     * @return BrandRepository
     */
    private function getRepository()
    {
        return new BrandRepository([
            'brand1' => ['host' => 'brand1.com', 'locale' => 'en_US'],
            'brand2' => ['host' => 'brand2.com', 'locale' => 'fr_FR']
        ]);
    }
}
