<?php

namespace AlloCine\BrandBundle\Tests\Kernel;

use AlloCine\BrandBundle\Kernel\TestKernel;

class BrandableKernelTest extends \PHPUnit_Framework_TestCase
{
    public function testDirectories()
    {
        $kernel = new TestKernel('dev', false, 'brand1');

        $this->assertSame(dirname($kernel->getRootDir()).'/var/cache/dev/brand1', $kernel->getCacheDir());
        $this->assertSame(dirname($kernel->getRootDir()).'/var/logs', $kernel->getLogDir());
    }

    public function testSetBrand()
    {
        $kernel = new TestKernel('dev', false, 'brand1');
        $kernel->setBrand('brand2');

        $this->assertSame('brand2', $kernel->getBrand());
    }

    public function testName()
    {
        $kernel = new TestKernel('dev', false, 'brand1');

        $this->assertSame('Brand1', $kernel->getName());
    }

    public function testNameWithDebug()
    {
        $kernel = new TestKernel('dev', true, 'brand1');

        $this->assertSame('Brand1Debug', $kernel->getName());
    }

    public function testSerialize()
    {
        $kernel = new TestKernel('dev', false, 'brand1');

        $clone = unserialize(serialize($kernel));

        $this->assertSame($kernel->getBrand(), $clone->getBrand());
    }

    /**
     * @expectedException \LogicException
     * @expectedExceptionMessage Brand can only be changed when kernel is not booted
     */
    public function testSetBrandWhileBooted()
    {
        $kernel = new TestKernel('dev', true, 'brand1');
        $kernel->boot();
        $kernel->setBrand('brand2');
    }

    public function testRegisterContainerConfigurationWithNoEnvForBrand()
    {
        $kernel = new TestKernel('dev', false, 'brand1');

        $loader = $this
            ->getMockBuilder('Symfony\Component\Config\Loader\LoaderInterface')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $loader
            ->expects($this->at(0))
            ->method('load')
            ->with($kernel->getRootDir().'/config/config_dev.yml')
        ;

        $loader
            ->expects($this->at(1))
            ->method('load')
            ->with($kernel->getRootDir().'/config/brand1/config.yml')
        ;

        $kernel->registerContainerConfiguration($loader);
    }

    public function testRegisterContainerConfigurationWithEnvForBrand()
    {
        $kernel = new TestKernel('dev', true, 'brand2');

        $loader = $this
            ->getMockBuilder('Symfony\Component\Config\Loader\LoaderInterface')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $loader
            ->expects($this->at(0))
            ->method('load')
            ->with($kernel->getRootDir().'/config/config_dev.yml')
        ;

        $loader
            ->expects($this->at(1))
            ->method('load')
            ->with($kernel->getRootDir().'/config/brand2/config_dev.yml')
        ;

        $kernel->registerContainerConfiguration($loader);
    }

    public function testRegisterContainerConfigurationWithNoConfigForBrand()
    {
        $kernel = new TestKernel('dev', true, 'brand3');

        $loader = $this
            ->getMockBuilder('Symfony\Component\Config\Loader\LoaderInterface')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $loader
            ->expects($this->once())
            ->method('load')
            ->with($kernel->getRootDir().'/config/config_dev.yml')
        ;

        $kernel->registerContainerConfiguration($loader);
    }
}
