<?php

namespace AlloCine\BrandBundle\Model;

class BrandRepository
{
    /**
     * @var array
     */
    private $brands;

    /**
     * @param array $brands
     */
    public function __construct(array $brands)
    {
        $this->brands = $brands;
    }

    /**
     * @param string $name
     *
     * @return array
     */
    public function get($name)
    {
        if (!array_key_exists($name, $this->brands)) {
            throw new \InvalidArgumentException(sprintf('Could not find brand "%s".', $name));
        }

        return $this->brands[$name];
    }

    /**
     * @return array
     */
    public function all()
    {
        return $this->brands;
    }

    /**
     * @return string[]
     */
    public function getAvailableBrands()
    {
        return array_keys($this->brands);
    }
}
