<?php

namespace AlloCine\BrandBundle\DependencyInjection\Binding;

use AlloCine\BrandBundle\Model\BrandRepository;
use AlloCine\BrandBundle\Model\FolderRepository;
use Symfony\Component\DependencyInjection\ContainerBuilder;

class AllocineI18nBinding
{
    /**
     * @var BrandRepository
     */
    private $brandRepository;

    /**
     * @var FolderRepository
     */
    private $folderRepository;

    public function __construct(BrandRepository $brandRepository, FolderRepository $folderRepository)
    {
        $this->brandRepository = $brandRepository;
        $this->folderRepository = $folderRepository;
    }

    /**
     * @param ContainerBuilder $container
     * @param array            $config
     * @param array            $binding
     */
    public function bind(ContainerBuilder $container, array $binding)
    {
        $bundles = array_keys($container->getParameter('kernel.bundles'));

        if (!in_array('AlloCineI18NBundle', $bundles)) {
            return;
        }


        $sourcePathes = [];
        $locales = [];

        foreach ($binding['sourceFolders'] as $tag) {
            $sourcePathes = array_merge($sourcePathes, $this->folderRepository->getAllTaggedFolders($tag));
        }

        foreach ($this->brandRepository->all() as $brand) {
            $locales[] = $brand['locale'];
        }

        $container->prependExtensionConfig('allo_cine_i18_n', [
            'locales' => array_unique($locales),
            'sourcePaths' => $sourcePathes
        ]);
    }
}
