<?php

namespace AlloCine\BrandBundle\Command;

use AlloCine\BrandBundle\Kernel\BrandableKernel;
use Symfony\Bundle\FrameworkBundle\Command\CacheClearCommand as BaseCacheClearCommand;
use Symfony\Component\HttpKernel\KernelInterface;

/**
 * Override of CacheClearCommand because of the TempKernel
 */
class CacheClearCommand extends BaseCacheClearCommand
{
    protected static $defaultName = 'cache:clear'; // Avoid warning in Sf > 3.4.0

    /**
     * @param KernelInterface|BrandableKernel $parent
     * @param string                          $namespace
     * @param string                          $parentClass
     * @param string                          $warmupDir
     *
     * @return KernelInterface
     */
    protected function getTempKernel(KernelInterface $parent, $namespace, $parentClass, $warmupDir)
    {
        /** @var BrandableKernel $tempKernel */
        $tempKernel = parent::getTempKernel($parent, $namespace, $parentClass, $warmupDir);
        $tempKernel->setBrand($parent->getBrand());

        return $tempKernel;
    }
}
