<?php

declare(strict_types=1);

namespace AlloCine\BrandBundle\Tests;

use Symfony\Component\HttpKernel\KernelInterface;
use Exception;
use Override;
use Symfony\Bundle\FrameworkBundle\Test\WebTestCase as BaseWebTestCase;

abstract class WebTestCase extends BaseWebTestCase
{
    /**
     * @param $name
     *
     * @return object
     *
     * @throws Exception
     */
    public function get(string $name)
    {
        if (!static::$kernel instanceof KernelInterface) {
            throw new Exception(sprintf('You must call static::bootKernel before call "container->get(\'%s\')"', $name));
        }

        return static::$kernel->getContainer()->get($name);
    }

    /**
     * Creates a Kernel.
     *
     * Available options:
     *
     *  * environment
     *  * debug
     *
     * @param array $options An array of options
     *
     * @return KernelInterface A KernelInterface instance
     */
    #[Override]
    protected static function createKernel(array $options = []): KernelInterface
    {
        if (null === static::$class) {
            static::$class = static::getKernelClass();
        }

        return new static::$class(
            $options['environment'] ?? 'test',
            $options['debug'] ?? true,
            $options['brand'] ?? null
        );
    }
}
