<?php

declare(strict_types=1);

namespace AlloCine\BrandBundle\Console;

use Symfony\Bundle\FrameworkBundle\Console\Application as BaseApplication;
use Symfony\Component\HttpKernel\KernelInterface;
use Symfony\Component\Console\Input\InputOption;

/**
 * Application add brand option for every command
 */
class Application extends BaseApplication
{
    public function __construct(KernelInterface $kernel)
    {
        parent::__construct($kernel);

        $this->getDefinition()->addOption(new InputOption('--brand', 'b', InputOption::VALUE_REQUIRED, 'Application Brand.', $kernel->getBrand()));
    }
}
