# What is AllocineBrandBundle ?

The main goal of this bundle is to allow a website to be displayed with different views, routes and domains.

Here at Allociné we call this "brands", hence the name of the bundle.

# How to install it ?

Add this to your composer.json :

```json
{
    "require": {
        "allocine/brand-bundle": "dev-master"
    }
}
```

Now you need not only to add the bundle to your kernel, but also change the kernel a little bit by
extending `BrandableKernel` and letting it handle `getCacheDir`, `getLogDir` and `registerContainerConfiguration`.
Here is a simple kernel that will do the job :


```php
use AlloCine\BrandBundle\Kernel\BrandableKernel;

class AppKernel extends BrandableKernel
{
    public function registerBundles()
    {
        $bundles = array(
            new Symfony\Bundle\FrameworkBundle\FrameworkBundle(),
            new Symfony\Bundle\SecurityBundle\SecurityBundle(),
            new Symfony\Bundle\TwigBundle\TwigBundle(),
            new Symfony\Bundle\MonologBundle\MonologBundle(),
            new Symfony\Bundle\SwiftmailerBundle\SwiftmailerBundle(),
            new Sensio\Bundle\FrameworkExtraBundle\SensioFrameworkExtraBundle(),
            new AlloCine\BrandBundle\AlloCineBrandBundle(),
            new AppBundle\AppBundle(), // your application
        );

        if (in_array($this->getEnvironment(), array('dev', 'test'))) {
            $bundles[] = new Symfony\Bundle\DebugBundle\DebugBundle();
            $bundles[] = new Symfony\Bundle\WebProfilerBundle\WebProfilerBundle();
            $bundles[] = new Sensio\Bundle\DistributionBundle\SensioDistributionBundle();
            $bundles[] = new Sensio\Bundle\GeneratorBundle\SensioGeneratorBundle();
        }

        return $bundles;
    }

    /**
     * @return string
     */
    public function getRootDir()
    {
        return __DIR__;
    }
}

```

Finally, let's change the console entry point (`bin/console`) to handle brands :

```php

#!/usr/bin/env php
<?php
use AlloCine\BrandBundle\Console\Application;
use Symfony\Component\Console\Input\ArgvInput;
use Symfony\Component\Debug\Debug;

set_time_limit(0);

$loader = require __DIR__.'/../app/autoload.php';

$input = new ArgvInput();
$env = $input->getParameterOption(['--env', '-e'], getenv('SYMFONY_ENV') ?: 'dev');
$debug = getenv('SYMFONY_DEBUG') !== '0' && !$input->hasParameterOption(['--no-debug', '']) && $env !== 'prod';

$brand = $input->getParameterOption(array('--brand', '-b'), getenv('SF_BRAND') ?: 'yourDefaultBrandHere');


if ($debug) {
    Debug::enable();
}

$kernel = new AppKernel($env, $debug, $brand);
$application = new Application($kernel);
$application->run($input);
```

You are now ready to go !

# Basic Usage

The first thing you need to do is declaring the brands as the bundle will refuse to use any non declared brands.
Let's say we have many websites for selling fishes.

```yml
allo_cine_brand:
    brands:
        fishstore:
            host: www.fishstore.dev # Used for cross-brands links
            locale: en_US # The default locale
        boutiquepoisson:
            host: www.boutiquepoisson.dev
            locale: fr_FR
```

But that's not enough, each brand has it's own views and urls, so let's declare a route for our shop cart :

```yml
cart:
    path:
        fishstore: /cart/view
        boutiquepoisson: /mon-panier
    defaults:
        _controller: AppBundle:Cart:index
```

Ok, so now, every time you visit `www.fishstore.dev/cart/view` you reach the right controller. But how to handle
different views ?

Just by declaring where to find them :

```yml
brands:
    # [...] brands declaration as seen above
    folders:
        views:
            path: "%kernel.root_dir%/Resources/views/{brand}"
            tags: ['twig'] # This is important as it tells the bundle it is a view folder.
```

With this setting, every time a call to the `render` method of Twig, the template are searched in the specified folder.
For instance, with fishstore : `render('home.html.twig')` will resolve to the file `%kernel.root_dir%/Resources/views/fishstore`.

You are now ready to multi-brand ! Take a look at the [advanced usages](Resources/doc/advanced.md).

# FAQ
## How do I disable a route for a brand ?

Sometime a route is available for a brand and not for the other, simply omit it in the routing :

```yml
cart:
    path:
        fishstore: /cart/view
        # boutiquepoisson: /mon-panier <- Will throw a 404 for this brand.
    defaults:
        _controller: AppBundle:Cart:index
```
