<?php

namespace AlloCine\BrandBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

class Configuration implements ConfigurationInterface
{
    /**
     * @inheritdoc
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();

        $treeBuilder
            ->root('brand')
                ->children()
                    ->arrayNode('bindings')
                        ->useAttributeAsKey('id')
                        ->prototype('variable')->end()
                    ->end()
                    ->arrayNode('folders')
                        ->useAttributeAsKey('id')
                        ->prototype('array')
                            ->children()
                                ->scalarNode('path')->end()
                                ->arrayNode('tags')
                                    ->prototype('scalar')->end()
                                ->end()
                                ->scalarNode('commonFolder')->defaultNull()->end()
                            ->end()
                        ->end()
                    ->end()
                    ->arrayNode('brands')
                        ->useAttributeAsKey('id')
                        ->prototype('array')
                            ->children()
                                ->scalarNode('host')->isRequired()->end()
                                ->scalarNode('locale')->isRequired()->end()
                                ->variableNode('extras')->defaultValue([])->end()
                            ->end()
                        ->end()
                    ->end()
                    ->arrayNode('builtins')
                        ->addDefaultsIfNotSet()
                        ->children()
                            ->arrayNode('cache')
                                ->addDefaultsIfNotSet()
                                ->children()
                                    ->booleanNode('enabled')
                                        ->defaultFalse()
                                        ->info('Enables the cache listener. Usually based on environment.')
                                    ->end()
                                    ->booleanNode('skip')
                                        ->defaultFalse()
                                        ->info('If true, skip the cache. Usually based on kernel.debug.')
                                    ->end()
                                    ->scalarNode('default_ttl')->defaultValue(3600)->end()
                                ->end()
                            ->end()
                        ->end()
                    ->end()
                ->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
