<?php

namespace Tests\BrandBundle\Tests\Routing;

use AlloCine\BrandBundle\Routing\BrandRouter;
use Symfony\Component\Routing\Route;
use Symfony\Component\Routing\RouteCollection;

class BrandRouterTest extends \PHPUnit_Framework_TestCase
{
    public function testGenerate()
    {
        $routes = new RouteCollection();

        $routes->add('brand1__foo', new Route('/brand1-foo'));
        $routes->add('brand2__foo', new Route('/brand2-foo'));

        $router = new BrandRouter($this->getServiceContainer($routes), 'foo');
        $router->setDefaultBrand('brand1');

        $this->assertSame('/brand1-foo', $router->generate('foo'));
        $this->assertSame('/brand2-foo', $router->generate('foo', ['_brand' => 'brand2']));
    }

    /**
     * @expectedException Symfony\Component\Routing\Exception\ResourceNotFoundException
     * @expectedExceptionMessage Unable to generate a URL for the named route "foo" as such route does not exist for brand "brand2"
     */
    public function testUnknownBrandRoute()
    {
        $routes = new RouteCollection();

        $routes->add('brand1__foo', new Route('/brand1-foo'));

        $router = new BrandRouter($this->getServiceContainer($routes), 'foo');
        $router->setDefaultBrand('brand2');

        $router->generate('foo');
    }

    /**
     * snippet from Symfony\Bundle\FrameworkBundle\Tests\Routing\RouterTest
     */
    private function getServiceContainer(RouteCollection $routes)
    {
        $loader = $this->getMock('Symfony\Component\Config\Loader\LoaderInterface');

        $loader
            ->expects($this->any())
            ->method('load')
            ->will($this->returnValue($routes))
        ;

        $sc = $this->getMock('Symfony\\Component\\DependencyInjection\\Container', ['get']);

        $sc
            ->expects($this->once())
            ->method('get')
            ->will($this->returnValue($loader))
        ;

        return $sc;
    }
}
