<?php

namespace AlloCine\BrandBundle\Tests\Kernel;

use AlloCine\BrandBundle\Kernel\TestKernel;

class BrandableKernelTest extends \PHPUnit_Framework_TestCase
{
    public function testDirectories()
    {
        $kernel = new TestKernel('dev', false, 'brand1');

        $this->assertSame($kernel->getProjectDir().'/var/cache/dev/brand1', $kernel->getCacheDir());
        $this->assertSame($kernel->getProjectDir().'/var/log', $kernel->getLogDir());
    }

    public function testSetBrand()
    {
        $kernel = new TestKernel('dev', false, 'brand1');
        $kernel->setBrand('brand2');

        $this->assertSame('brand2', $kernel->getBrand());
    }

    public function testName()
    {
        $kernel = new TestKernel('dev', false, 'brand1');

        $this->assertSame('Brand1', $kernel->getName());
    }

    public function testNameWithDebug()
    {
        $kernel = new TestKernel('dev', true, 'brand1');

        $this->assertSame('Brand1Debug', $kernel->getName());
    }

    public function testSerialize()
    {
        $kernel = new TestKernel('dev', false, 'brand1');

        $clone = unserialize(serialize($kernel));

        $this->assertSame($kernel->getBrand(), $clone->getBrand());
    }

    /**
     * @expectedException \LogicException
     * @expectedExceptionMessage Brand can only be changed when kernel is not booted
     */
    public function testSetBrandWhileBooted()
    {
        $kernel = new TestKernel('dev', true, 'brand1');
        $kernel->boot();
        $kernel->setBrand('brand2');
    }

    public function testConfigureContainerWithNoEnvForBrand()
    {
        $kernel = new TestKernel('dev', false, 'brand1');

        $container = $this
            ->getMockBuilder('\Symfony\Component\DependencyInjection\ContainerBuilder')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $loader = $this
            ->getMockBuilder('Symfony\Component\Config\Loader\LoaderInterface')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $loader
            ->expects($this->at(0))
            ->method('load')
            ->with($kernel->getConfigDir().'/config_dev.{php,xml,yaml,yml}')
        ;

        $loader
            ->expects($this->at(1))
            ->method('load')
            ->with($kernel->getConfigDir().'/brand1/config.{php,xml,yaml,yml}')
        ;

        $kernel->configureContainer($container, $loader);
    }

    public function testConfigureContainerWithEnvForBrand()
    {
        $kernel = new TestKernel('dev', true, 'brand2');

        $container = $this
            ->getMockBuilder('\Symfony\Component\DependencyInjection\ContainerBuilder')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $loader = $this
            ->getMockBuilder('Symfony\Component\Config\Loader\LoaderInterface')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $loader
            ->expects($this->at(0))
            ->method('load')
            ->with($kernel->getProjectDir().'/config/config_dev.{php,xml,yaml,yml}')
        ;

        $loader
            ->expects($this->at(1))
            ->method('load')
            ->with($kernel->getProjectDir().'/config/brand2/config_dev.{php,xml,yaml,yml}')
        ;

        $kernel->configureContainer($container, $loader);
    }

    public function testConfigureContainerWithNoConfigForBrand()
    {
        $kernel = new TestKernel('dev', true, 'brand3');

        $container = $this
            ->getMockBuilder('\Symfony\Component\DependencyInjection\ContainerBuilder')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $loader = $this
            ->getMockBuilder('Symfony\Component\Config\Loader\LoaderInterface')
            ->disableOriginalConstructor()
            ->getMock()
        ;

        $loader
            ->expects($this->once())
            ->method('load')
            ->with($kernel->getProjectDir().'/config/config_dev.{php,xml,yaml,yml}')
        ;

        $kernel->configureContainer($container, $loader);
    }
}
